// ADDED TO COPE WITH ENCODERS
// ---
// https://playground.arduino.cc/Main/RotaryEncoders#Example16
//
// 'threshold' is the Debounce Adjustment factor for the Rotary Encoder.
//
// The threshold value I'm using limits it to 100 half pulses a second
//

// My encoder has 12 pulses per 360deg rotation and the specs say
// it is rated at a maximum of 100rpm.


// This threshold will permit my encoder to reach 250rpm so if it was connected
// to a motor instead of a manually operated knob I
// might possibly need to adjust it to 25000. However, this threshold
// value is working perfectly for my situation
//
volatile unsigned long threshold = 100; // 10000;

// Working variables for the interrupt routines
//
volatile unsigned long int0time = 0;
volatile unsigned long int1time = 0;

volatile uint8_t int0signal = 0; // Channel A's value of encoder
volatile uint8_t int1signal = 0; // Channel B's value of encoder

volatile uint8_t int0history = 0;
volatile uint8_t int1history = 0;
// -----------

// Broches PWM utilisées (attention: ceci doit correspondre à la configuration des cavaliers)
#define pwmMoteur1  10
#define pwmMoteur2  9

int pin_A = 2; // Output A of encoder // Yellow Wire (is A according to datasheet)
int pin_B = 3; // Output B of encoder // White Wire (is B according to datasheet)

volatile long code = pow(2, 20); // Encoder's value (centered in 2^20);
int Boucle = 0; // Type of loop (0 : open loop / 1 : closed loop)

//----open loop----//
long Zero_Duty = 0;           // See3Sigma Datasheet
long Duty_Cycle = Zero_Duty; // PWM/Signal received in serial port
long PWM = Zero_Duty;        // PWM/signal to send to the motor

//---closed loop---//
long Consigne = pow(2, 20);
long C = Consigne; // Position setpoint received in serial port
long Control = 0; // PWM/signal to send to the motor
float Gain;      // Gain's value of the closed loop

// ---- interrupt related stuff ---- //
// 16000000 / 1024(prescaler) => period of 64 mu.sec
// 1 s corresponds to 15625 periods and 15625 = 5^6 = 5^3 5^3 = 125*125

long Num_Interrupt_counts = 125;
long Wanted_Size_TCNT2 = 125;
long Size_TCNT2 = 256;
long Interrupt_Count = 0;

//-----------------//
unsigned long SimulationTime = 3000000; // time of simulation (in microsecond);
unsigned long Time = 0, t = 0; // Time's value (in microsecond)

int i;

// ----------------------------------------------------------------- //
//-----------------------Function definition------------------------//
// ----------------------------------------------------------------- //
void Send_Data(long P, long t, int C); // Function to send data in serial port


// ----------------------------------------------------------------- //
//----------------------------Void Setup----------------------------//
// ----------------------------------------------------------------- //
void setup() {
  // --- Time Interrupts Setup --- //

  cli();//DISABLE INTERRUPTS
  // SETTING UP INTERRUPT ON TIMER 2 (PWM PINS 3 & 11)
  bitClear(TCCR2A, WGM20); // WGM20 = 0
  bitClear(TCCR2A, WGM21); // WGM21 = 0

  //  TCCR1A = 0; // To configure normal mode of Timer
  TCCR2B = 0b00000111;  // To configure normal mode of Timer - three last byte is the value of the prescaler (here 1024 -- NOTE config for timer 2 differs from timer 1) => Clock cycle lasts 64 mu.s
  TIMSK2 = 0b00000001; // Allow Timer's interrupt
  TCNT2 = 0; // Initial value of Timer
  sei(); // Allow all interrupts

  // --- cf. 3 Sigma Datasheet --- //
 // Définition des broches PWM en sortie
  pinMode(pwmMoteur1, OUTPUT);
  pinMode(pwmMoteur2, OUTPUT);


  // --- Encoder pins and variables Setup --- //
  pinMode(pin_A, INPUT); // To configure input
  pinMode(pin_B, INPUT);

  digitalWrite(pin_A, HIGH); //Enables Internal PullUP
  digitalWrite(pin_B, HIGH); //Enables Internal PullUP
  // https://www.arduino.cc/reference/en/language/functions/digital-io/digitalwrite/

  // --- Encoder Interrupts Setup --- //
  attachInterrupt(INT0, Tic_A, CHANGE); // Encoder Tic on channel A // INT0 is the pin 2 interrupt
  attachInterrupt(INT1, Tic_B, CHANGE); // Encoder Tic on channel B // INT0 is the pin 3 interrupt

  // --- Serial Com setup --- //
  Serial.begin(115200); // Define the baudrate (byte per second)
  while ( Serial.available () > 0) {
    Serial.read ();
  } ; // Clear the serial port
}

// ----------------------------------------------------------------- //
//----------------------------Void Loop-----------------------------//
// ----------------------------------------------------------------- //
void loop() {

  while (Serial.available () < 12); // While there are less than 12 bytes in serial port --> do nothing. Arduino is a slave

  Interrupt_Count = 0; // Reset the counter that allows STARTUP after 1s
  Boucle = (Serial.read() - 48); // Read byte's value in ASCII and convert it
  switch (Boucle) { // Begin of switch case

    // ============== //
    //    OPEN LOOP   // 
    // ============== //
    case 0: // Therefore open loop
      for (i = 1; i <= 3; i++) {
        Duty_Cycle += (Serial.read() - 48) * pow(10, 3 - i); // Recover the PWM's Value centered in 500
      }
      Duty_Cycle -= 500; // Center PWM's value in 0
      Duty_Cycle = constrain(Duty_Cycle, Zero_Duty-255, Zero_Duty+ 255); // CONSTRAIN CONTROL WITHIN INTERVAL [-400, 400]
      PWM = Zero_Duty; // Reinitialize PWM's value to send to the motor
      TCNT2 = Size_TCNT2 - Wanted_Size_TCNT2; // Reinitiate the Timer's value so there is an interrupt every second / 125
      t = micros(); // Read time's value since the program's begining
      // Serial.print('$');
      
      while ((micros() - t) < SimulationTime) { // while the simulation is not terminated
        Time = micros() - t; // Take the time's value since the simulation's begining
        Send_Data(code, Time, PWM); // Send : encoder'value, time's value, PWM's value in the serial port
        // SEND PWM TO THE MOTOR //
        if (PWM >= 0){
          analogWrite(pwmMoteur2, 255);
          analogWrite(pwmMoteur1, 255 - PWM);} 
        else{analogWrite(pwmMoteur2, 255+PWM);
          analogWrite(pwmMoteur1, 255);}
      }
      break;
    // ====================== //
    //   \END OPEN LOOP \END  // 
    // ====================== //


    // ================ //
    //    CLOSED LOOP   // 
    // ================ //
    case 1: // Therefore closed loop

      for (i = 1; i <= 7; i++) {
        C += (Serial.read() - 48) * pow(10, 7 - i); // Recover the Position setpoint's Value
        // C stands for "consigne"
      }
      C -= pow(10, 6); // Centers the SetPoint around 0.
      for (i = 1; i <= 5; i++) {
        Gain += (Serial.read() - 48) * pow(10, 2 - i); // Recover the Gain's Value divided By 1000
      }
      TCNT2 = Size_TCNT2 - Wanted_Size_TCNT2;
      t = micros(); // Read time's value since the program's begining
      while ((micros() - t) < SimulationTime) { // while the simulation is not terminated
        Time = micros() - t; // Take the time's value of since the simulation's begining
        Control = Zero_Duty + Gain * (Consigne - code); // Calculate control to send to motor
        Control = constrain(Control, Zero_Duty - 255, Zero_Duty + 255); // CONSTRAIN CONTROL WITHIN INTERVAL [-255, 255]
        Send_Data(code, Time, Control); // Send : encoder'value, time's value, control's value in the serial port
        if (Control >= 0){
          analogWrite(pwmMoteur2, 255);
          analogWrite(pwmMoteur1, 255 - Control);} 
        else{analogWrite(pwmMoteur2, 255+Control);
             analogWrite(pwmMoteur1, 255);}
      }
      break;
    // ========================== //
    //    \END CLOSED LOOP \END   // 
    // ========================== //

    case 2: // reset
      Consigne = pow(2, 20); // Reinitiate position setpoint to zero (centered in 2^20)
      code = pow(2, 20); // Reinitiate Encoder's value to zero (centered in 2^20)
      // B = digitalRead(pin_B); // Read value of channel B
      // A = digitalRead(pin_A); // Read value of channel A
      Duty_Cycle = Zero_Duty; // Reinitiate PWM received in serial port
      PWM  = Zero_Duty; // Reinitiate PWM to send to the motor
      // SyRen.writeMicroseconds(PWM); // Send PWM to the motor
        analogWrite(pwmMoteur2, 255); // STOP the motor
        analogWrite(pwmMoteur1, 255); // STOP the motor
      break;
  }

  C = pow(2, 20); // Reinitiate position setpoint received in serial port to zero (centered in 2^20)
  PWM = Zero_Duty; // Reinitiate PWM received in serial port
  Gain = 0; // Reinitiate PGain's value
  analogWrite(pwmMoteur2, 255); // STOP the motor
  analogWrite(pwmMoteur1, 255); // STOP the motor
//    if (micros()-t > SimulationTime) { // While simulation is not terminated
    Serial.println(); // send data
//  }
}

//-----------------Send data in serial port-----------------//
void Send_Data(long P, long t, int C) {
  P = constrain(P, 0, pow(2, 21)); // Saturate Encoder's Value between 0 and 2^21

  String Data_Time = String(t); // Convert time's Value into string
  String Data_PWM = String(C + 500 - Zero_Duty); // Center Encoder's Value in 500 and convert it into string
  String Data_Position = String(P); // Convert Encoder's Value into string

  String Data = Data_Time + "/" + Data_PWM + "/" + Data_Position + "|"; //Create the message : "[Time]/[PWM]/[Position]|"

  if (t < SimulationTime) { // While simulation is not terminated
    Serial.print(Data); // send data
  }
}

//------------------------Motor Control------------------------//
// Not A function, THIS IS DONE DIRECTLY IN THE MAIN CODE


//---------------------Encoder readings---------------------//
void Tic_A() {
  if ( micros() - int0time < threshold )
    return;
  int0history = int0signal;
  int0signal = bitRead(PIND, pin_A);
  if ( int0history == int0signal )
    return;
  int0time = micros();
  if ( int0signal == int1signal )
    code++;
  else
    code--;
}

void Tic_B() {
  if ( micros() - int1time < threshold )
    return;
  int1history = int1signal;
  int1signal = bitRead(PIND, pin_B);
  if ( int1history == int1signal )
    return;
  int1time = micros();
  if ( int0signal == int1signal )
    code--;
  else
    code++;
}


//------------------------Timer's interrupt------------------------//

ISR(TIMER2_OVF_vect) {
  if (Interrupt_Count++ >= Num_Interrupt_counts) {
    PWM = Duty_Cycle; // PWM to send to the motor take the value of the PWM received in serial port
    Consigne = C; // Position setpoint to send to the motor take the value of the Position setpoint received in serial port
  }
  TCNT2 = Size_TCNT2 - Wanted_Size_TCNT2; // Reinitiate the Timer's value so there is an interrupt every second/125
}
