// ADDED TO COPE WITH ENCODERS
// ---
// https://playground.arduino.cc/Main/RotaryEncoders#Example16
//
// 'threshold' is the Debounce Adjustment factor for the Rotary Encoder.
//
// The threshold value I'm using limits it to 100 half pulses a second
//

// My encoder has 12 pulses per 360deg rotation and the specs say
// it is rated at a maximum of 100rpm.


// This threshold will permit my encoder to reach 250rpm so if it was connected
// to a motor instead of a manually operated knob I
// might possibly need to adjust it to 25000. However, this threshold
// value is working perfectly for my situation

volatile unsigned long threshold = 100; //<-- Test value // 500 (default value); // 10000; // Check the above text

int i; // This is a generic counter
//  ------------------------------------------------ //
//  ------------------------------------------------ //

//  ------------------------------------------------ //
//    Working variables for the interrupt routines   //
//  ------------------------------------------------ //
volatile unsigned long int0time = 0;
volatile unsigned long int1time = 0;

volatile uint8_t int0signal = 0; // Channel A's value of encoder
volatile uint8_t int1signal = 0; // Channel B's value of encoder

volatile uint8_t int0history = 0;
volatile uint8_t int1history = 0;
//  ------------------------------------------------ //
//  ------------------------------------------------ //


//  ------------------------------------------------ //
//  --------------       SYREN         ------------- //
#include <Servo.h>  // This allows us to use the Syren in RC mode

Servo SyRen;
int RCpin = 10; // Timer 1 (i.e. Servo Lib) is linked to pins 9 / 10
//  ------------------------------------------------ //
//  ------------------------------------------------ //


//  ------------------------------------------------ //
//  ------------------  ENCODER PINS --------------- //
int pin_A = 2; // Output A of encoder // Yellow Wire (is A according to datasheet)
int pin_B = 3; // Output B of encoder // White Wire (is B according to datasheet)

volatile long code = pow(2,20); // Encoder's value (centered in 2^20);
 
const long Enc_Resolution = 8256; // Check Motor documentation Or Matlab code (48*172)
//  ------------------------------------------------ //
//  ------------------------------------------------ //


//  ------------------------------------------------ //
//  ----------------- LOOP PARAMETERS -------------- //
//  ------------------------------------------------ //

int Boucle = 0; // Type of loop (0 : open loop / 1 : closed loop)

//---- OPEN LOOP ----//

long Zero_Duty = 1475;        // See RC mode on Syren 10A DataSheet
long Duty_Cycle = Zero_Duty; // PWM/Signal received in serial port 
long PWM = Zero_Duty;        // PWM/signal to send to the motor

//--- CLOSED LOOP ---//
// long Consigne = pow(2,20); 

float Consigne = 0;  // In the case of speed control
float C = Consigne; // Position setpoint received in serial port


// CONTROLLER PART //

float Gain;      // Gain's value of the closed loop (propotional)
float Gain_Integral;      // Gain's value of the closed loop  (integral)
float Integral_Part = 0;
long Control = 0; // PWM/signal to send to the motor
float Previous_Time = 0;

// ----------- SPEED COMPUTATION ------------ //
// volatile long dCode =0; //  Used to compute speed // dCode = number of Ticks
float dt =1, dCode =0; // Time values used in order to compute speed

/* long codes4Speed[10]; // Should be equal to speed_comp_last+1
long times4Speed[10]; */

int speed_comp_last = 2; 
float codes4Speed[3],times4Speed[3];
int kill_Speed_comp_at_startup = 10, Do_I_kill_speed =0; // To remove weird things that happen when t is small

volatile float speed_measurement = 0, speed_measurement_Converted = 0; // Computed speed
float output_speed = 0, alpha_filter=0.7;

//  ------------------------------------------------ //
//  ------------------------------------------------ //


//  ------------------------------------------------ //
// ----        INTERRUPTS RELATED STUFF          ---- //
// 16000000 / 1024(prescaler) => period of 64 mu.sec
// 1 s corresponds to 15625 periods and 15625 = 5^6 = 5^3 5^3 = 125*125

long Num_Interrupt_counts = 125;
long Wanted_Size_TCNT2 = 125;
long Size_TCNT2 = 256; 
long Interrupt_Count = 0;

unsigned long SimulationTime = 3000000; // time of simulation (in microsecond);
unsigned long Time = 0, t = 0; // Time's value (in microsecond)
// t -> time at which the open / closed loop starts
// Time -> elapsed time  since the beginning of the open / closed loop
//  ------------------------------------------------ //
//  ------------------------------------------------ //


// ------------------------------------------------------------------- //
//----------------------- FUNCTIONS PROTOTYPES ------------------------//
// ------------------------------------------------------------------ //
void Send_Data(long P, long t, int C); // Function to send data in serial port

// ----------------------------------------------------------------- //
//--------------------  Setup Routine (VOID) ------------------------//
// ----------------------------------------------------------------- //
void setup() {
 // --- Time Interrupts Setup --- //
   
  cli();//DISABLE INTERRUPTS

// SETTING UP INTERRUPT ON TIMER 2 (PWM PINS 3 & 11)
  bitClear(TCCR2A,WGM20); // WGM20 = 0
  bitClear(TCCR2A,WGM21); // WGM21 = 0

//  TCCR1A = 0; // To configure normal mode of Timer
  TCCR2B = 0b00000111;  // To configure normal mode of Timer - three last byte is the value of the prescaler (here 1024 -- NOTE config for timer 2 differs from timer 1) => Clock cycle lasts 64 mu.s
  TIMSK2 = 0b00000001; // Allow Timer's interrupt
  TCNT2 = 0; // Initial value of Timer
  sei(); // Allow all interrupts

// --- Servo Machine (to send RC signal to SyRen card) --- //
  SyRen.attach(RCpin,1000,2000);  
  SyRen.writeMicroseconds(PWM);


// --- Encoder pins and variables Setup --- //
  pinMode(pin_A,INPUT); // To configure input
  pinMode(pin_B,INPUT);
  
//  A = digitalRead(pin_A); // Read value of channel A
//  B = digitalRead(pin_B); // Read value of channel B
    
//  A = digitalRead(pin_A);
//  B = digitalRead(pin_B);

//  oldState=((A<<pin_A)|(B<<pin_B)); // Initialize oldState

  digitalWrite(pin_A, HIGH); //Enables Internal PullUP
  digitalWrite(pin_B, HIGH); //Enables Internal PullUP
// https://www.arduino.cc/reference/en/language/functions/digital-io/digitalwrite/

// --- Encoder Interrupts Setup --- //
  attachInterrupt(INT0,Tic_A, CHANGE); // Encoder Tic on channel A // INT0 is the pin 2 interrupt
  attachInterrupt(INT1,Tic_B, CHANGE); // Encoder Tic on channel B // INT0 is the pin 3 interrupt

  // --- Serial Com setup --- //
  Serial.begin(19200); // Define the baudrate (byte per second)
  while ( Serial.available ()>0){Serial.read ();} ; // Clear the serial port


// for(i = 0; i<=speed_comp_last; i++){Serial.print(codes4Speed[i]);}  // FOR DEBUG //
   } 

// ----------------------------------------------------------------- //
//------------------------    MAIN LOOP   ---------------------------//
// ----------------------------------------------------------------- //
void loop() {  
  
  while (Serial.available ()<12); // While there are less of 12 bytes in serial port, do nothing

  Interrupt_Count = 0; // Reset the counter that allows STARTUP after 1s
  Boucle = (Serial.read()-48); // Read byte's value in ASCII and convert it
  switch(Boucle){ // Begin of switch case
    
    case 0: // Therefore open loop
      for(i = 1; i<=3; i++){
        Duty_Cycle += (Serial.read()-48)*pow(10,3-i); // Recover the PWM's Value centered in 500
      }
      Duty_Cycle -= 500; // Center PWM's value in 0
      Duty_Cycle = constrain(Duty_Cycle,Zero_Duty-400,Zero_Duty+400); // CONSTRAIN CONTROL WITHIN INTERVAL [-400, 400]
      PWM = Zero_Duty; // Reinitialize PWM's value to send to the motor
      TCNT2 = Size_TCNT2-Wanted_Size_TCNT2; // Reinitiate the Timer's value so there is an interrupt every second / 125
      t = micros(); // Read time's value since the program's begining 
      while ((micros() - t)<SimulationTime){ // while the simulation is not terminated
        Time = micros() - t; // Take the time's value since the simulation's begining

        // ADDED TO EXIT SPEED //
        
        for(i=1;i<=speed_comp_last;i++){
          codes4Speed[i-1] = codes4Speed[i];
          times4Speed[i-1] = times4Speed[i];
        }
        codes4Speed[speed_comp_last] = code ; // code -> encoder value
        times4Speed[speed_comp_last] = Time;  // Time -> this loop's type

        dt = times4Speed[speed_comp_last]-times4Speed[0]; // dt in micro sec (10^-6)
        dCode = codes4Speed[speed_comp_last]-codes4Speed[0]; // dcode in Ticks

        speed_measurement =   dCode/dt; // float(dCode) / float(dt); // speed (numerically) computed in Ticks/microsec

        speed_measurement_Converted =  speed_measurement*6*pow(10,7)/Enc_Resolution;


         if ( Do_I_kill_speed < kill_Speed_comp_at_startup)
                { speed_measurement=0;
                speed_measurement_Converted =0;
                Do_I_kill_speed++;
        //        Serial.println(666); // Works -> should be ereased
        //        Serial.println('_'); // Works -> should be ereased 
                }



        // ADDED TO EXIT SPEED //

        output_speed = alpha_filter*output_speed+(1-alpha_filter)*speed_measurement_Converted;

             
        Send_Data(output_speed, Time,PWM); // Send : encoder'value, time's value, PWM's value in the serial port
        SyRen.writeMicroseconds(PWM); // Send PWM to the motor
      }
      break;
/* ------------------- */
/*   END OF OPEN LOOP  */
/* ------------------- */
    case 1: // Therefore closed loop
      for(i = 1; i<=7; i++){ 
        C += (Serial.read()-48)*pow(10,6-i); // Recover the Speed setpoint's Value  divided by 10 // in tr/min
      }
     // C -= pow(10,6); // centers the SetPoint around 0 No need for speed (April 6 2022)
      for(i = 1; i<=5; i++){
        Gain += (Serial.read()-48)*pow(10,3-i); // Recover the Gain's Value divided By 100 
      }
      for(i = 1; i<=6; i++){
        Gain_Integral += (Serial.read()-48)*pow(10,4-i); // Recover the Gain's Value divided By 100 
      }
/* NOTE -> FRAME should be 19 bytes long (1 (loop) + 7 (setpoint) + 5 (prop Gain) + 6 (integral gain)) */

      
    /* Serial.println(C);
      Serial.println(Gain);
      Serial.println('_');
      Serial.println(Gain_Integral); */
            
      TCNT2 = Size_TCNT2-Wanted_Size_TCNT2;
      t = micros(); // Read time's value since the program's begining   
    
      while ((micros() - t)<SimulationTime){ // while the simulation is not terminated
        Time = micros() - t; // Take the time's value since the simulation's beginning     
        
       for(i=1;i<=speed_comp_last;i++){
          codes4Speed[i-1] = codes4Speed[i];
          times4Speed[i-1] = times4Speed[i];
        }
        codes4Speed[speed_comp_last] = code ; // code -> encoder value
        times4Speed[speed_comp_last] = Time;  // Time -> this loop's type

        dt = times4Speed[speed_comp_last]-times4Speed[0]; // dt in micro sec (10^-6)
        dCode = codes4Speed[speed_comp_last]-codes4Speed[0]; // dcode in Ticks

        speed_measurement =   dCode/dt; // float(dCode) / float(dt); // speed (numerically) computed in Ticks/microsec

/*        for(i = 0; i<=speed_comp_last; i++){Serial.println(times4Speed[i]);}
        Serial.println('_');
        Serial.println(dt);
        Serial.println('_');
*/  
        speed_measurement_Converted =  speed_measurement*6*pow(10,7)/Enc_Resolution;

        if ( Do_I_kill_speed < kill_Speed_comp_at_startup)
        { speed_measurement=0;
        speed_measurement_Converted =0;
        Do_I_kill_speed++;
//        Serial.println(666); // Works -> should be ereased
//        Serial.println('_'); // Works -> should be ereased 
        }
        
        
/*       Serial.println(speed_measurement); // TROP PETIT //
         Serial.println('_');
         Serial.println(speed_measurement_Converted);
         Serial.println('_');*/
     //    Serial.println(Consigne);
     //    Serial.println('_');
          
//        Previous_code = code;
//        Previous_Time = Time;
        
//        Serial.println(speed_measurement_Converted);
          
         output_speed = alpha_filter*output_speed+(1-alpha_filter)*speed_measurement_Converted;          

         Integral_Part = Integral_Part + (Consigne - output_speed)*(Time-Previous_Time)*pow(10,-3);
         Previous_Time = Time;

        
        Control = Zero_Duty + Gain*(Consigne - output_speed)+Gain_Integral*Integral_Part; // Calculate control to send to motor
//         Control = Zero_Duty + 300;
//       Serial.println(Control);
//        Serial.println('_');

        
        Control = constrain(Control,Zero_Duty-400,Zero_Duty+400); // CONSTRAIN CONTROL WITHIN INTERVAL [-400, 400]
        SyRen.writeMicroseconds(Control); // Send PWM to the motor 
        Send_Data(output_speed, Time, Control); // Send : encoder'value, time's value, control's value in the serial port   
      }
      break;
/* --------------------- */
/*   END OF CLOSED LOOP  */
/* --------------------- */


    case 2: // reset

//      Consigne = pow(2,20); // Reinitiate position setpoint to zero (centered in 2^20)
      Consigne = 0; // In the case of Speed Control
      code = pow(2,20);  // Reinitiate Encoder's value to zero (centered in 2^20)
      dCode = 0; // In the case of speed control
      // B = digitalRead(pin_B); // Read value of channel B
      // A = digitalRead(pin_A); // Read value of channel A
      Duty_Cycle = Zero_Duty; // Reinitiate PWM received in serial port
      PWM  = Zero_Duty; // Reinitiate PWM to send to the motor
      SyRen.writeMicroseconds(PWM); // Send PWM to the motor
      break;
/* --------------------- */
/*     END OF RESET      */
/* --------------------- */
  }
  
  C = pow(2,20); // Reinitiate position setpoint received in serial port to zero (centered in 2^20)
  PWM = Zero_Duty; // Reinitiate PWM received in serial port
  Gain = 0; // Reinitiate PGain's value
  SyRen.writeMicroseconds(PWM); // STOP the motor   
  Do_I_kill_speed =0; // Set killing parameter back to 0
  for(i=0;i<=speed_comp_last;i++){
          codes4Speed[i] = 0; // Note : could be done with memset...
          times4Speed[i] = 0;
        }         
 }


//--------------------------------------------------//
//----------------- EXTRA FUNCTIONS-----------------//


//-----------------Send data in serial port-----------------//
void Send_Data(long P, long t, int C){
  
  int j;

  P = constrain(P,0,pow(2,21)); // Saturate Encoder's Value between 0 and 2^21
  
  String Data_Time = String(t); // Convert time's Value into string
  String Data_PWM = String(C+500- Zero_Duty); // Center Encoder's Value (C) around 500 and convert it into string
  String Data_Position = String(P*100); // Convert Encoder's Value into string

/*  for(j = 6; t<pow(10,j); j--){
      Data_Time = "0" + Data_Time; // Add "0" so the size of time's data is equal to 6 bytes
    }
  for(j = 6; P<pow(10,j); j--){
      Data_Position = "0" + Data_Position; // Add "0" so the size of Encoder's data is equal to 6 bytes
    }*/
  String Data = Data_Time + "/" + Data_PWM + "/" + Data_Position + "|"; //Create the message : "[Time]/[PWM]/[Position]|"
  
  if (t < SimulationTime){ // While simulation is not terminated
    Serial.print(Data); // send data
  }
}


//------------------  MOTOR ACTUATION   ------------------------//
// Not A function, THIS IS DONE DIRECTLY IN THE MAIN CODE
// ---> search for : SyRen.writeMicroseconds(PWM);


//---------------------ENCODER INTERRUPTS---------------------//

void Tic_A(){
    if ( micros() - int0time < threshold )
      return;
    int0history = int0signal;
    int0signal = bitRead(PIND, pin_A);
    if ( int0history == int0signal )
      return;
    int0time = micros();
    if ( int0signal == int1signal )
      code++;
    else
      code--;
    
/*    A = digitalRead(pin_A);
    B = digitalRead(pin_B);
    byte state=((A<<pin_A)|(B<<pin_B));
    if(oldState & (1<<pin_B))
        if(state & (1<<pin_A))
            code++; // code--;
  else
      code--;// code++;
  else{
      if(state & (1<<pin_A))
          code--; //code++;
      else
    code++;//code--;
  }
    oldState=state;*/
}

void Tic_B(){    
  if ( micros() - int1time < threshold )
    return;
  int1history = int1signal;
  int1signal = bitRead(PIND, pin_B);
  if ( int1history == int1signal )
    return;
  int1time = micros();
  if ( int0signal == int1signal )
      code--;
   else
      code++;
   /* B = digitalRead(pin_B);
    A = digitalRead(pin_A);
    byte state=((A<<pin_A)|(B<<pin_B));
    if(oldState & (1<<pin_A))
        if(state & (1<<pin_B))
            code--; // code++;
  else
      code++; //code--;
  else{
      if(state & (1<<pin_B))
    code++; //code--
      else
    code--; //code++
  }
    oldState=state;*/
}

//-----------------------------------------------------------------//
//------------------------TIMER INTERRUPT------------------------//

ISR(TIMER2_OVF_vect){
  if (Interrupt_Count++ >= Num_Interrupt_counts){
  PWM = Duty_Cycle; // PWM to send to the motor take the value of the PWM received in serial port
  Consigne = C; // Position setpoint to send to the motor take the value of the Position setpoint received in serial port
  }
  TCNT2 = Size_TCNT2-Wanted_Size_TCNT2; // Reinitiate the Timer's value so there is an interrupt every second/125
  }


//-----------------------------------------------------------------//
//------------------------  FRAME FORMAT  ------------------------//
// This is the format that should be sent to the arduino ///

// OPEN LOOP FORMAT



// CLOSED LOOP FORMAT








  
